---
obsidianUIMode: preview
---

This section helps you more easily run battles in which the characters face large numbers of monsters.

To accommodate running horde combat, we change the rules for running monsters in two ways: adjusting how we track damage done to monsters in a horde, and how we adjudicate attack rolls and saving throws for the horde. You can use these approaches individually or together when running large numbers of monsters.

## Pooling Damage

Pooling damage means that instead of tracking the damage dealt to individual monsters, you track damage dealt to the horde as a whole. Add up the damage of each attack, regardless of which monster in the horde is hit. Then every time the total of damage taken is higher than the hit points of a single monster in the horde, remove the last monster hit and reset the damage dealt to zero.

If enough damage is dealt with a single attack to kill multiple monsters, remove that number of monsters, subtracting their hit points from the damage dealt until there isn't enough damage remaining to kill another monster.

To make this math even easier, you can round each monster's hit points to the nearest 5 or 10.

If the horde is hit by a damage-dealing area effect (including spells), remove any creatures that took damage equal to or greater than their hit points after determining their saving throw results. If the damage isn't enough to kill a single monster, tally up the total damage done and remove monsters one at a time, subtracting their hit points from the damage until all damage is accounted for.

For even easier adjudication, you can simply remove any monsters that fail their saving throws, without worrying about their hit points.

## Determine Targets

The circumstances of the encounter dictate how many members of the horde can attack the characters. Unless the circumstances dictate otherwise, assume the horde evenly spreads its attacks across all characters. If certain characters step ahead of the rest of the party or block choke points that prevent the horde from reaching other characters, you can redirect the horde's attacks to the characters stepping forward.

## Adjudicating Attacks and Saving Throws

Whenever rolling individual attacks or saving throws would be a burden, assume that one quarter of attacks or saving throws rolled by the horde succeed. Round up or down depending on the circumstances, such as when determining how many attacks succeed against characters with wildly different ACs.

If all the creatures in a horde have advantage on an attack or saving throw, increase the number of successful attacks or saving throws to one half. If the horde has disadvantage, reduce the number to one in ten.

If any member of the horde is affected by an effect that leaves them incapacitated, remove them from play.

If you prefer to roll dice, roll twice when a group of monsters all make attacks or saving throws. On each success, one quarter of the monster attacks or saving throws succeed. If both rolls fail, no attacks or saving throws succeed.

## Adjudicating Areas of Effect

Adjudicate the number of creatures caught up in an area of effect based on the circumstances, but leaning toward more creatures rather than fewer. You can use the following as a baseline for the number of tightly packed creatures in a horde that are affected in a given area:

* **Tiny Area (5-foot radius):** Two creatures
* **Small Area (10- to 15-foot radius):** Four creatures
* **Large Area (20-foot radius):** Sixteen creatures
* **Huge Area (30-foot radius or more):** Thirty-two or more creatures
* **Short Line (60 feet):** Six creatures
* **Long Line (120 feet):** Eight creatures

## Tips and Tricks

* Describe these horde combat rules to the players so everyone understands how they work. Always adjudicate combat to the characters' benefit, and help the players achieve their goals.
* Use evocative descriptions to flavor a horde. Worry less about the mechanics and more about the feeling involved in fighting a huge horde of monsters.
* Avoid using hordes with monsters of different types in a single battle. Instead, use a single stat block and describe any physical differences between monsters narratively.
* Augment a horde with a handful of more powerful monsters when desired. Track the hit points and attacks of these powerful monsters normally.
* As hordes diminish to a manageable level, return to tracking individual hit points, attacks, and saving throws normally.
